* File input2.inc
* This input file uses full constraint set (modified),
* Declare scalars and set values for noncalculated ones

SCALARS


  MaxLogMass mass (kg) of glass log            /1650/
  ViscMin    minimum viscosity (PaS)           /5.0/
  ViscMax    maximum viscosity (PaS)           /6/
  ECondMin   minimum E-conductivity (S per m)  /25.0/
  ECondMax   maximum E-conductivity (S per m)  /35/
  DissMaxPCT max release rate (PCT) (g per m2) /10.0/
  DissMaxMCC max release rate (MCC) (g per m2) /18/
  Cryst1Bnd  bound for Crystal1 constrait      /3.0/
  Cryst2Bnd  bound for Crystal2 constrait      /.08/
  Cryst3Bnd  bound for Crystal3 constrait      /.225/
  Cryst4Bnd  bound for Crystal4 constrait      /.18/
  Cryst5Bnd  bound for Crystal5 constrait      /.18/ ;

* Bounds for Visc, Econd and DissMaxMCC modified

* Assign upper and lower bounds on composition variables

* Frit composition bounds - nonzero upper limit indicates
* that component is allowed in frit & will be optimized

FF.LO('SiO2') = 0;
FF.LO('B2O3') = 0;
FF.LO('Na2O') = 0;
FF.LO('Li2O') = 0;
FF.LO('CaO')  = 0;
FF.LO('MgO')  = 0;
FF.LO('Fe2O3')= 0;
FF.LO('Al2O3')= 0;
FF.LO('ZrO2') = 0;
FF.LO('Other')= 0;
FF.LO(K)      = 0;

FF.UP('SiO2') = 1.0;
FF.UP('B2O3') = 1.0;
FF.UP('Na2O') = 1.0;
FF.UP('Li2O') = 1.0;
FF.UP('CaO')  = 1.0;
FF.UP('MgO')  = 1.0;
FF.UP('Fe2O3')= 1.0;
FF.UP('Al2O3')= 1.0;
FF.UP('ZrO2') = 1.0;
FF.UP('Other')= 1.0;
FF.UP(K)      = 1.0;

* Glass composition bounds on ten glass model components plus solubility
*       components

FG.LO('SiO2') = .42;
FG.LO('B2O3') = .05;
FG.LO('Na2O') = .05;
FG.LO('Li2O') = .01;
FG.LO('CaO')  = 0;
FG.LO('MgO')  = 0;
FG.LO('Fe2O3')= .02;
FG.LO('Al2O3')= 0;
FG.LO('ZrO2') = 0;
FG.LO('Other')= .01;

FG.LO('Cr2O3') =0;
FG.LO('F')     =0;
FG.LO('P2O5')  =0;
FG.LO('SO3')   =0;
FG.LO('NobMet')=0;

FG.UP('SiO2') = .57;
FG.UP('B2O3') = .20;
FG.UP('Na2O') = .20;
FG.UP('Li2O') = .07;
FG.UP('CaO')  = .10;
FG.UP('MgO')  = .08;
FG.UP('Fe2O3')= .15;
FG.UP('Al2O3')= .15;
FG.UP('ZrO2') = .13;
FG.UP('Other')= .10;

FG.UP('Cr2O3') =.005;
FG.UP('F')     =.017;
FG.UP('P2O5')  =.01;
FG.UP('SO3')   =.005;
FG.UP('NobMet')=.025;

* Assign initial values to start calculation with nonzero values

TMWG.L = 700;
TMFG.L = 900;
FG.L(I)   = 0.1;
FF.L('SiO2') = .5;
FF.L('B2O3') = .2;
FF.L('Na2O') = .2;
FF.L('Li2O') = .05;
FF.L('CaO')  = .03;
FF.L('MgO')  = .02;
FF.L('Fe2O3')= 0;
FF.L('Al2O3')= 0;
FF.L('ZrO2') = 0;
FF.L('Other')= 0;

* Specify optimization algorithm to be used
* OPTION NLP = CONOPT